<?php

$html_id = ct_get_element_id($settings);
$source = $widget->get_setting('source', '');
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
extract(ct_get_posts_of_grid('portfolio', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$img_size = $widget->get_setting('img_size', '');
$show_title = $widget->get_setting('show_title', '');
$show_category = $widget->get_setting('show_category', '');
$button_text = $widget->get_setting('button_text', '');
$btn_link_target = $widget->get_setting('btn_link_target', '');

$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel ct-slick-arrow-middle ct-slick-arrow-center',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
] );
$gradient_color = grupi_get_opt( 'gradient_color' );
$gradient_color_form = '#f4a21a';
if ( !empty($gradient_color['from']) && isset($gradient_color['from']) ) {
    $gradient_color_form = $gradient_color['from'];
}
$gradient_color_to = '#ffde00';
if ( !empty($gradient_color['to']) && isset($gradient_color['to']) ) {
    $gradient_color_to = $gradient_color['to'];
}
if (is_array($posts)): ?>
    <div id="<?php echo esc_attr($html_id) ?>" class="ct-portfolio-carousel2 ct-slick-slider">
        <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
            <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
            <?php
                $default_size = '340x510'; 
                if(!empty($img_size)) {
                    $default_size = $img_size;
                }
                foreach ($posts as $post): 
                $img_id = get_post_thumbnail_id($post->ID);
                $img = ct_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $default_size,
                ));
                $thumbnail = $img['thumbnail'];
                $portfolio_custom_link = get_post_meta($post->ID, 'portfolio_custom_link', true);
                $featured_img_url = get_the_post_thumbnail_url($post->ID, 'full'); 
                if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                    <div class="carousel-item slick-slide">
                        <div class="grid-item-inner <?php echo esc_attr($settings['ct_animate']); ?>">
                            <a href="<?php echo esc_url($featured_img_url); ?>" class="item--zoom"><i class="flaticon-maximize"></i></a>
                            <div class="item--featured">
                                <a target="<?php echo esc_attr($settings['btn_link_target']); ?>" href="<?php if(!empty($portfolio_custom_link)) { echo esc_url($portfolio_custom_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"><?php echo ct_print_html($thumbnail); ?></a>
                            </div>
                            <div class="item--meta">
                                <?php if($show_category == 'true'): ?>
                                    <div class="item--category">
                                        <?php the_terms( $post->ID, 'portfolio-category', '', ' ' ); ?>
                                    </div>
                                <?php endif; ?>
                                <?php if($show_title == 'true'): ?>
                                    <h4 class="item--title">
                                        <a target="<?php echo esc_attr($settings['btn_link_target']); ?>" href="<?php if(!empty($portfolio_custom_link)) { echo esc_url($portfolio_custom_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                            <?php echo esc_attr(get_the_title($post->ID)); ?>
                                        </a>
                                    </h4>
                                <?php endif; ?>
                                <svg xmlns="http://www.w3.org/2000/svg" width="58" height="43" viewBox="0 0 58 43">
                                    <defs>
                                        <linearGradient id="ct-portfolio-gradient-icon" x1="0%" y1="0%" x2="100%" y2="0%">
                                            <stop offset="0%" style="stop-color:<?php echo esc_attr($gradient_color_to); ?>;stop-opacity:1" />
                                            <stop offset="100%" style="stop-color:<?php echo esc_attr($gradient_color_form); ?>;stop-opacity:1" />
                                        </linearGradient>
                                    </defs>
                                    <path fill="url(#ct-portfolio-gradient-icon)" d="M-76,83c0.865-14.868,5.424-27.347,15-34,9.2-6.394,19.169-4.737,33-4,12.43,0.662,25.13.451,32-1C25.321,39.5,43.176,24.079,58,1l5,102Z"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>