<?php
ct_add_custom_widget(
    array(
        'name' => 'ct_mailchimp_form',
        'title' => esc_html__('Case Mailchimp Form', 'grupi'),
        'icon' => 'eicon-email-field',
        'categories' => array(Case_Theme_Core::CT_CATEGORY_NAME),
        'scripts' => [
            'ct-inline-css-js',
        ],
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'source_section',
                    'label' => esc_html__('Color Settings', 'grupi'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'style',
                            'label' => esc_html__('Layout', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'style1' => 'Style 1',
                                'style2' => 'Style 2',
                            ],
                            'default' => 'style1',
                        ),
                        array(
                            'name' => 'input_color',
                            'label' => esc_html__('Input Color', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .ct-mailchimp.ct-mailchimp1 .mc4wp-form .mc4wp-form-fields input' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'input_bg_color',
                            'label' => esc_html__('Input Background Color', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .ct-mailchimp.ct-mailchimp1 .mc4wp-form .mc4wp-form-fields input' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'input_border_color',
                            'label' => esc_html__('Input Focus Border Color', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .ct-mailchimp1.style1 .mc4wp-form .mc4wp-form-fields input[type="email"], {{WRAPPER}} .ct-mailchimp1.style1 .mc4wp-form .mc4wp-form-fields input[type="text"]' => 'border-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'input_focus_border_color',
                            'label' => esc_html__('Input Focus Border Color', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .ct-mailchimp1.style1 .mc4wp-form .mc4wp-form-fields input[type="email"]:focus, {{WRAPPER}} .ct-mailchimp1.style1 .mc4wp-form .mc4wp-form-fields input[type="text"]:focus' => 'border-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'button_text_color',
                            'label' => esc_html__('Button Text Color', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .ct-mailchimp .mc4wp-form [type="submit"]' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'button_bg_color',
                            'label' => esc_html__('Button Background Color', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .ct-mailchimp .mc4wp-form [type="submit"]' => 'background-color: {{VALUE}};background-image:none;',
                            ],
                        ),
                        array(
                            'name' => 'button_bg_color_gradient',
                            'label' => esc_html__('Button Background Color Gradient', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                        ),
                    ),
                ),
            ),
        ),
    ),
    get_template_directory() . '/elementor/core/widgets/'
);