<?php
ct_add_custom_widget(
    array(
        'name' => 'ct_client_grid',
        'title' => esc_html__('Client Grid', 'grupi'),
        'icon' => 'eicon-person',
        'categories' => array(Case_Theme_Core::CT_CATEGORY_NAME),
        'scripts' => [
            'imagesloaded',
            'isotope',
            'ct-post-masonry-widget-js',
            'ct-post-grid-widget-js',
        ],
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_list',
                    'label' => esc_html__('Content', 'grupi'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'clients',
                            'label' => esc_html__('Clients', 'grupi'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'client_name',
                                    'label' => esc_html__('Client Name', 'grupi'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'client_link',
                                    'label' => esc_html__('Client URL', 'grupi'),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'client_logo',
                                    'label' => esc_html__('Client Logo', 'grupi'),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'client_logo_hover',
                                    'label' => esc_html__('Client Logo Hover', 'grupi'),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                    'label_block' => true,
                                ),
                            ),
                            'title_field' => '{{{ client_name }}}',
                        ),
                    ),
                ),
                array(
                    'name' => 'grid_section',
                    'label' => esc_html__('Grid', 'grupi' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'col_xs',
                            'label' => esc_html__('Columns XS Devices', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => esc_html__('1', 'grupi' ),
                                '2' => esc_html__('2', 'grupi' ),
                                '3' => esc_html__('3', 'grupi' ),
                                '4' => esc_html__('4', 'grupi' ),
                                '6' => esc_html__('6', 'grupi' ),
                            ],
                        ),
                        array(
                            'name' => 'col_sm',
                            'label' => esc_html__('Columns SM Devices', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '2',
                            'options' => [
                                '1' => esc_html__('1', 'grupi' ),
                                '2' => esc_html__('2', 'grupi' ),
                                '3' => esc_html__('3', 'grupi' ),
                                '4' => esc_html__('4', 'grupi' ),
                                '6' => esc_html__('6', 'grupi' ),
                            ],
                        ),
                        array(
                            'name' => 'col_md',
                            'label' => esc_html__('Columns MD Devices', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => esc_html__('1', 'grupi' ),
                                '2' => esc_html__('2', 'grupi' ),
                                '3' => esc_html__('3', 'grupi' ),
                                '4' => esc_html__('4', 'grupi' ),
                                '6' => esc_html__('6', 'grupi' ),
                            ],
                        ),
                        array(
                            'name' => 'col_lg',
                            'label' => esc_html__('Columns LG Devices', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '4',
                            'options' => [
                                '1' => esc_html__('1', 'grupi' ),
                                '2' => esc_html__('2', 'grupi' ),
                                '3' => esc_html__('3', 'grupi' ),
                                '4' => esc_html__('4', 'grupi' ),
                                '6' => esc_html__('6', 'grupi' ),
                            ],
                        ),
                        array(
                            'name' => 'col_xl',
                            'label' => esc_html__('Columns XL Devices', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '4',
                            'options' => [
                                '1' => esc_html__('1', 'grupi' ),
                                '2' => esc_html__('2', 'grupi' ),
                                '3' => esc_html__('3', 'grupi' ),
                                '4' => esc_html__('4', 'grupi' ),
                                '6' => esc_html__('6', 'grupi' ),
                            ],
                        ),
                    ),
                ),
            ),
        ),
    ),
    get_template_directory() . '/elementor/core/widgets/'
);